---
title: Contents
description: Explore Tabler Illustrations folder structure
summary: The Tabler Illustrations package is thoughtfully structured to provide designers and developers with an array of high-quality assets. This guide explores the various folders and their contents, helping users make the most of these resources.
---

The Tabler Illustrations package offers a wide range of visual assets designed to meet the needs of modern web and graphic design. These illustrations are not only aesthetically pleasing but also highly versatile, supporting various formats and themes for seamless integration into different projects.

## Folder Structure

Once downloaded, unzip the compressed folder and you’ll see something like this:

```
tabler-illustrations/
├── eps/
|	├── dark/
|	└── light/
├── figma/ 
├── pdf/ 
|  ├── dark/
|  └── light/
├── png/ 
|  ├── dark/
|  └── light/
├── png-background/ 
|	├── dark/
|	└── light/
├── svg/ 
|  ├── dark/
|  └── light/
├── svg-css-autodark/ 
└── svg-css-variables/
 	├── dark/
 	└── light/
```

## Understanding the File Structure in Tabler Illustrations

The **Tabler Illustrations** package is organized into a clear and efficient folder structure to streamline the use of its high-quality assets. Below is a breakdown of its key directories:

### 1. Vector Files: `eps/`
This folder contains EPS files for scalable vector illustrations.
- `dark/`: Dark-themed illustrations.
- `light/`: Light-themed illustrations.

### 2. Design File: `figma/`
This folder contains a Figma file, perfect for designers who work directly in Figma.

### 3. Document Files: `pdf/`
This folder contains PDF files, ideal for print or presentation use.
- `dark/`: Dark-themed illustrations.
- `light/`: Light-themed illustrations.

### 4. Transparent Images: `png/`
This folder stores PNG files with transparent backgrounds at 1600 × 1200px resolution.
- `dark/`: Dark-themed illustrations.
- `light/`: Light-themed illustrations.

### 5. Background Images: `png-background/`
This folder contains PNG files with a dark background for enhanced contrast.
- `dark/`: Dark-themed illustrations.
- `light/`: Light-themed illustrations.

### 6. Scalable Vector Graphics: `svg/`
This folder includes SVG files for scalable and customizable vector graphics.
- `dark/`: Dark-themed illustrations.
- `light/`: Light-themed illustrations.

### 7. Adaptive Graphics: `svg-css-autodark/`
This folder contains SVG files prepared to automatically adjust their colors based on user settings, providing a dynamic and adaptive visual experience.

### 8. Themed Graphics: `svg-css-variables/`
This folder contains SVG files using CSS variables for flexible theming.
- `dark/`: Dark-themed illustrations.
- `light/`: Light-themed illustrations.

This structure ensures easy access to various formats and themes, making Tabler Illustrations a versatile tool for developers and designers alike.

**Find out more and purchase Tabler Illustrations at [our website]({{ site.homepage }}/illustrations)**.